﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Module MainModule

    Private dsProducts As New DataSet
    Private dvProducts As DataView

    Private promptMessage As String = "Enter a product ID to display information or 'QUIT' to end this application."
    Private welcomeMessage As String = "Welcome to How-To Work with the Console Product Finder"


    Sub Main()

        Dim strInput As String
        Dim indexData As Integer

        Console.WriteLine(welcomeMessage)

        ' 使用 products 表填充数据集 dsProducts，
        ' 并根据 product ID 字段创建 products 表的排序视图。
        CreateDataSet()

        Console.WriteLine()
        Console.WriteLine(promptMessage)

        strInput = UCase(Console.ReadLine())
        While strInput <> "QUIT"

            ' 检查以确保输入一个数字作为产品 ID。
            While Not (IsNumeric(strInput) Or UCase(strInput) = "QUIT")
                Console.WriteLine("A numeric product ID is required.")
                Console.WriteLine("Please reenter the Product ID or QUIT to continue.")
                strInput = Console.ReadLine()
            End While

            ' 在遇到“quit”（退出）时退出。
            If UCase(strInput) = "QUIT" Then
                End
            End If

            ' 如果找到有效的产品 ID，则显示产品信息。
            ' 如果找不到该产品 ID，则显示异常消息。
            indexData = dvProducts.Find(strInput)
            If indexData = -1 Then
                Console.WriteLine("No product found.")
            Else
                Console.Write("Product Name: ")
                Console.WriteLine(dvProducts(indexData)("ProductName"))
                Console.Write("Quantity Per Unit: ")
                Console.WriteLine(dvProducts(indexData)("QuantityPerUnit"))
                Console.Write("Unit Price: ")
                Console.WriteLine(dvProducts(indexData)("UnitPrice"))
                Console.Write("Units In Stock: ")
                Console.WriteLine(dvProducts(indexData)("UnitsInStock"))
                Console.Write("Units on Order: ")
                Console.WriteLine(dvProducts(indexData)("UnitsOnOrder"))
                Console.Write("Reorder Level: ")
                Console.WriteLine(dvProducts(indexData)("ReorderLevel"))
                Console.Write("Discontinued: ")
                If CBool(dvProducts(indexData)("Discontinued")) = False Then
                    Console.WriteLine("False")
                Else
                    Console.WriteLine("True")
                End If
            End If
            Console.WriteLine()
            Console.WriteLine(promptMessage)
            strInput = UCase(Console.ReadLine())
        End While
        End

    End Sub

    ''' <summary>
    ''' 从项目的嵌入资源中读取 Products.xml 数据集。
    ''' </summary>
    Private Sub CreateDataSet()
        Dim thisExe As System.Reflection.Assembly
        thisExe = System.Reflection.Assembly.GetExecutingAssembly()
        Dim xmlFile As System.IO.Stream
        xmlFile = thisExe.GetManifestResourceStream("ConsoleApp.Products.xml")
        dsProducts.ReadXml(xmlFile)
        dvProducts = New DataView(dsProducts.Tables(0))
        dvProducts.Sort = "ProductID"
    End Sub
End Module
